<?php
/**
 * Plugin Name: Icono Flotante @Jparral
 * Description: Plugin para añadir un icono flotante con hipervínculo en WordPress, si, ahora tambien hago plugins.
 * Version: 1.5.3
 * Author: <a target="_blank" href="https://tfeolandia.com.ar/">@Jparral</a>
 */

// Hook para añadir el menú de opciones en el admin
add_action('admin_menu', 'mi_icono_flotante_menu');

function mi_icono_flotante_menu() {
    add_options_page('Configuración de Icono Flotante', 'Icono Flotante', 'manage_options', 'mi-icono-flotante', 'mi_icono_flotante_opciones');
}

// Función para mostrar y guardar las opciones de configuración
function mi_icono_flotante_opciones() {
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        update_option('mi_icono_flotante_url', sanitize_text_field($_POST['mi_icono_flotante_url']));
        update_option('mi_icono_flotante_icono', sanitize_text_field($_POST['mi_icono_flotante_icono']));
        echo '<div id="message" class="updated fade"><p>Opciones guardadas</p></div>';
    }

    $url = get_option('mi_icono_flotante_url', '');
    $icono = get_option('mi_icono_flotante_icono', '');

    // Verificar si hay una versión nueva disponible
    if (isset($_POST['check_update'])) {
        $remote_version_url = 'https://feolandia.com.ar/plugins/iconito/iconito.json';
        $current_version = '1.5.2'; // Versión actual del plugin

        $remote_version = wp_remote_get($remote_version_url);

        if (!is_wp_error($remote_version) && isset($remote_version['body'])) {
            $remote_version = json_decode($remote_version['body']);

            if (version_compare($current_version, $remote_version->version, '<')) {
                $plugin_slug = plugin_basename(__FILE__);
                $plugin_transient = get_site_transient('update_plugins');

                if (!isset($plugin_transient->response[$plugin_slug])) {
                    $plugin_transient->response[$plugin_slug] = new stdClass();
                }

                $plugin_transient->response[$plugin_slug]->slug = dirname($plugin_slug);
                $plugin_transient->response[$plugin_slug]->new_version = $remote_version->version;
                $plugin_transient->response[$plugin_slug]->url = 'https://feolandia.com.ar/plugins/iconito';
                $plugin_transient->response[$plugin_slug]->package = $remote_version->download_url;
                $plugin_transient->response[$plugin_slug]->info_url = $remote_version->info_url; // Nueva propiedad para los detalles del plugin

                set_site_transient('update_plugins', $plugin_transient);

                echo '<div id="message" class="updated fade"><p>Versión actualizada del plugin disponible</p></div>';
            } else {
                echo '<div id="message" class="updated fade"><p>El plugin ya está actualizado a la última versión</p></div>';
            }
        } else {
            echo '<div id="message" class="error fade"><p>Error al verificar la actualización del plugin</p></div>';
        }
    }

    ?>
    <div class="wrap">
        <h2>Configuración de Icono Flotante</h2>
        <form method="post" action="">
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">URL del Hipervínculo:</th>
                    <td><input type="text" name="mi_icono_flotante_url" value="<?php echo esc_attr($url); ?>" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row">URL del Icono:</th>
                    <td><input type="text" name="mi_icono_flotante_icono" value="<?php echo esc_attr($icono); ?>" /></td>
                </tr>
            </table>
            <p class="submit">
                <input type="submit" class="button-primary" value="Guardar Cambios" />
                <input type="submit" class="button-secondary" value="Verificar Actualización" name="check_update" />
            </p>
        </form>
    </div>
    <?php
}

// Hook para añadir el icono al frontend
add_action('wp_footer', 'mi_icono_flotante');

function mi_icono_flotante() {
    $url = get_option('mi_icono_flotante_url');
    $icono = get_option('mi_icono_flotante_icono');

    if (!empty($url) && !empty($icono)) {
        echo '<a href="'. esc_url($url) .'" class="floating-icon">';
        echo '<img src="'. esc_url($icono) .'" alt="Icono">';
        echo '</a>';
    }
}

// Hook para añadir estilos CSS
add_action('wp_enqueue_scripts', 'mi_icono_flotante_estilos');

function mi_icono_flotante_estilos() {
    wp_enqueue_style('mi-icono-flotante-css', plugins_url('estilos.css', __FILE__));
}
?>
